/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.auiml.formatters;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmDataFormatter;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmDataFormatterWithProperties;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.ValidationException;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.DateValidator;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.IntegralValidator;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.RealValidator;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.RequiredValidator;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.StringValidator;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.TimeValidator;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.Validator;
import com.ibm.hwmca.fw.servlet.pmod.util.DateFormatter;
import com.ibm.hwmca.fw.servlet.pmod.util.NoStandardFormatterException;
import com.ibm.hwmca.fw.servlet.pmod.util.ObjectFormatter;
import com.ibm.hwmca.fw.servlet.pmod.util.TimeFormatter;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.DataFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class AuimlDefaultFormatter
implements PmDataFormatterWithProperties {
    private static final String TRACE_MASKD = "XCVTADFD";
    private static final String TRACE_MASKF = "XCVTADFF";
    private static final String TRACE_MASKT = "XCVTADFT";
    private Properties attributes;
    private PmDataFormatter formatter;
    private List validatorList;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;

    public void setProperties(Properties attributes) {
        if (attributes == null) {
            attributes = new Properties();
        }
        this.attributes = attributes;
        this.setupFormatter();
        this.setupValidators();
    }

    public PmDataFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(PmDataFormatter formatter) {
        this.formatter = formatter;
    }

    public void setAttribute(String attrName, String value) {
        if (attrName == null) {
            return;
        }
        Trace.trace(TRACE_MASKF, "setAttribute(" + attrName + ", " + value + ")");
        this.attributes.put(attrName, value);
        Iterator iterator = this.validatorList.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof StringValidator) {
                if (attrName.equals("maxLength")) {
                    try {
                        int max = Integer.parseInt(value);
                        ((StringValidator)o).setMaxLength(max);
                        Trace.trace(TRACE_MASKF, "Updated 'maxLength' value of StringValidator");
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Exception setting max length on string validator (" + value + "):" + e.getMessage());
                        ((StringValidator)o).setMaxLength(-1);
                    }
                    continue;
                }
                if (!attrName.equals("minLength")) continue;
                try {
                    int min = Integer.parseInt(value);
                    ((StringValidator)o).setMinLength(min);
                    Trace.trace(TRACE_MASKF, "Updated 'minLength' value of StringValidator");
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting min length on string validator (" + value + "):" + e.getMessage());
                    ((StringValidator)o).setMinLength(-1);
                }
                continue;
            }
            if (o instanceof IntegralValidator) {
                if (attrName.equals("maxValue")) {
                    try {
                        int max = Integer.parseInt(value);
                        ((IntegralValidator)o).setMaxValue(max);
                        Trace.trace(TRACE_MASKF, "Updated 'max' value of IntegralValidator");
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Exception setting max value on integral validator (" + value + "):" + e.getMessage());
                    }
                    continue;
                }
                if (!attrName.equals("minValue")) continue;
                try {
                    int min = Integer.parseInt(value);
                    ((IntegralValidator)o).setMinValue(min);
                    Trace.trace(TRACE_MASKF, "Updated 'min' value of IntegralValidator");
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting min value on integral validator (" + value + "):" + e.getMessage());
                }
                continue;
            }
            if (o instanceof RealValidator) {
                if (attrName.equals("maxValue")) {
                    try {
                        double max = Double.parseDouble(value);
                        ((RealValidator)o).setMaxValue(max);
                        Trace.trace(TRACE_MASKF, "Updated 'max' value of RealValidator");
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Exception setting max value on real validator (" + value + "):" + e.getMessage());
                    }
                    continue;
                }
                if (!attrName.equals("minValue")) continue;
                try {
                    double min = Double.parseDouble(value);
                    ((RealValidator)o).setMinValue(min);
                    Trace.trace(TRACE_MASKF, "Updated 'min' value of RealValidator");
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting min value on real validator (" + value + "):" + e.getMessage());
                }
                continue;
            }
            if (o instanceof TimeValidator) {
                if (attrName.equals("earliest")) {
                    try {
                        Calendar earlyCalendar = (Calendar)TimeFormatter.convert(value, class$java$util$Calendar == null ? AuimlDefaultFormatter.class$("java.util.Calendar") : class$java$util$Calendar);
                        ((TimeValidator)o).setEarliest(earlyCalendar);
                        Trace.trace(TRACE_MASKF, "Updated 'earliest' value of TimeValidator");
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Exception setting earliest value on time validator (" + value + "):" + e.getMessage());
                    }
                    continue;
                }
                if (!attrName.equals("latest")) continue;
                try {
                    Calendar earlyCalendar = (Calendar)TimeFormatter.convert(value, class$java$util$Calendar == null ? AuimlDefaultFormatter.class$("java.util.Calendar") : class$java$util$Calendar);
                    ((TimeValidator)o).setLatest(earlyCalendar);
                    Trace.trace(TRACE_MASKF, "Updated 'latest' value of TimeValidator");
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting earliest value on time validator (" + value + "):" + e.getMessage());
                }
                continue;
            }
            if (o instanceof DateValidator) {
                if (attrName.equals("earliest")) {
                    try {
                        Date earlyCalendar = (Date)DateFormatter.convert(value, class$java$util$Date == null ? AuimlDefaultFormatter.class$("java.util.Date") : class$java$util$Date);
                        ((DateValidator)o).setEarliest(earlyCalendar);
                        Trace.trace(TRACE_MASKF, "Updated 'earliest' value of DateValidator");
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Exception setting earliest value on date validator (" + value + "):" + e.getMessage());
                    }
                    continue;
                }
                if (!attrName.equals("latest")) continue;
                try {
                    Date earlyCalendar = (Date)DateFormatter.convert(value, class$java$util$Date == null ? AuimlDefaultFormatter.class$("java.util.Date") : class$java$util$Date);
                    ((DateValidator)o).setLatest(earlyCalendar);
                    Trace.trace(TRACE_MASKF, "Updated 'latest' value of DateValidator");
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting latest value on date validator (" + value + "):" + e.getMessage());
                }
                continue;
            }
            if (!(o instanceof RequiredValidator) || !value.equalsIgnoreCase("FALSE")) continue;
            Trace.trace(TRACE_MASKF, "removed RequiredValidator");
            iterator.remove();
        }
        if (attrName.equals("required") && value.equalsIgnoreCase("TRUE")) {
            boolean found = false;
            Iterator iterator2 = this.validatorList.iterator();
            while (iterator2.hasNext()) {
                Object o = iterator2.next();
                if (!(o instanceof RequiredValidator)) continue;
                found = true;
            }
            if (!found) {
                Trace.trace(TRACE_MASKF, "added RequiredValidator");
                this.validatorList.add(new RequiredValidator());
            }
        }
    }

    public String getAttribute(String attrName) {
        Trace.trace(TRACE_MASKT, "-> getAttribute(" + attrName + ")");
        Object o = this.attributes.get(attrName);
        if (o == null || !(o instanceof String)) {
            Trace.trace(TRACE_MASKT, "<- getAttribute() returns empty string");
            return "";
        }
        Trace.trace(TRACE_MASKT, "<- getAttribute() returns: " + o);
        return (String)o;
    }

    public boolean isNumberProperty() {
        String type = this.getAttribute("type");
        return type.equals("REAL") || type.equals("INTEGRAL");
    }

    private void setupFormatter() {
        Trace.trace(TRACE_MASKF, "-> setupFormatter()");
        String formatBinding = (String)this.attributes.get("FORMAT-BINDING");
        if (formatBinding != null && !formatBinding.equals("")) {
            try {
                this.formatter = (PmDataFormatter)Class.forName(formatBinding).newInstance();
                Trace.trace(TRACE_MASKF, "Set up formatter");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception setting up formatter (" + formatBinding + "): " + e.getMessage());
            }
        }
        Trace.trace(TRACE_MASKF, "<- setupFormatter()");
    }

    private void setupValidators() {
        String earliest;
        String maxValue;
        Trace.trace(TRACE_MASKT, "-> setupValidators()");
        this.validatorList = new ArrayList();
        String type = (String)this.attributes.get("type");
        if (type == null) {
            type = "";
        }
        if (type.equals("STRING")) {
            String minLength;
            StringValidator stringValidator = new StringValidator();
            String maxLength = (String)this.attributes.get("maxLength");
            if (maxLength != null && !maxLength.equals("")) {
                try {
                    int max = Integer.parseInt(maxLength);
                    stringValidator.setMaxLength(max);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting max length on string validator (" + maxLength + "):" + e.getMessage());
                }
            }
            if ((minLength = (String)this.attributes.get("minLength")) != null && !minLength.equals("")) {
                try {
                    int min = Integer.parseInt(minLength);
                    stringValidator.setMinLength(min);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting min length on string validator (" + minLength + "):" + e.getMessage());
                }
            }
            this.validatorList.add(stringValidator);
            Trace.trace(TRACE_MASKF, "added string validator");
        } else if (type.equals("INTEGRAL")) {
            String minValue;
            IntegralValidator integralValidator = new IntegralValidator();
            maxValue = (String)this.attributes.get("maxValue");
            if (maxValue != null && !maxValue.equals("")) {
                try {
                    int max = Integer.parseInt(maxValue);
                    integralValidator.setMaxValue(max);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting max value on integral validator (" + maxValue + "):" + e.getMessage());
                }
            }
            if ((minValue = (String)this.attributes.get("minValue")) != null && !minValue.equals("")) {
                try {
                    int min = Integer.parseInt(minValue);
                    integralValidator.setMinValue(min);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting min value on integral validator (" + minValue + "):" + e.getMessage());
                }
            }
            this.validatorList.add(integralValidator);
            Trace.trace(TRACE_MASKF, "added integral validator");
        } else if (type.equals("REAL")) {
            String minValue;
            RealValidator realValidator = new RealValidator();
            maxValue = (String)this.attributes.get("maxValue");
            if (maxValue != null && !maxValue.equals("")) {
                try {
                    double max = Double.parseDouble(maxValue);
                    realValidator.setMaxValue(max);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting max value on real validator (" + maxValue + "):" + e.getMessage());
                }
            }
            if ((minValue = (String)this.attributes.get("minValue")) != null && !minValue.equals("")) {
                try {
                    double min = Double.parseDouble(minValue);
                    realValidator.setMinValue(min);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting min value on real validator (" + minValue + "):" + e.getMessage());
                }
            }
            this.validatorList.add(realValidator);
            Trace.trace(TRACE_MASKF, "added real validator");
        } else if (type.equals("TIME")) {
            String latest;
            TimeValidator timeValidator = new TimeValidator();
            earliest = (String)this.attributes.get("earliest");
            if (earliest != null && !earliest.equals("")) {
                try {
                    Calendar earlyCalendar = (Calendar)TimeFormatter.convert(earliest, class$java$util$Calendar == null ? (class$java$util$Calendar = AuimlDefaultFormatter.class$("java.util.Calendar")) : class$java$util$Calendar);
                    timeValidator.setEarliest(earlyCalendar);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting earliest value on time validator (" + earliest + "):" + e.getMessage());
                }
            }
            if ((latest = (String)this.attributes.get("latest")) != null && !latest.equals("")) {
                try {
                    Calendar lateCalendar = (Calendar)TimeFormatter.convert(latest, class$java$util$Calendar == null ? (class$java$util$Calendar = AuimlDefaultFormatter.class$("java.util.Calendar")) : class$java$util$Calendar);
                    timeValidator.setLatest(lateCalendar);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting latest value on time validator (" + latest + "):" + e.getMessage());
                }
            }
            this.validatorList.add(timeValidator);
            Trace.trace(TRACE_MASKF, "added time validator");
        } else if (type.equals("DATE")) {
            String latest;
            DateValidator dateValidator = new DateValidator();
            earliest = (String)this.attributes.get("earliest");
            if (earliest != null && !earliest.equals("")) {
                try {
                    Date earlyCalendar = (Date)DateFormatter.convert(earliest, class$java$util$Date == null ? (class$java$util$Date = AuimlDefaultFormatter.class$("java.util.Date")) : class$java$util$Date);
                    dateValidator.setEarliest(earlyCalendar);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting earliest value on date validator (" + earliest + "):" + e.getMessage());
                }
            }
            if ((latest = (String)this.attributes.get("latest")) != null && !latest.equals("")) {
                try {
                    Date lateCalendar = (Date)DateFormatter.convert(latest, class$java$util$Date == null ? (class$java$util$Date = AuimlDefaultFormatter.class$("java.util.Date")) : class$java$util$Date);
                    dateValidator.setLatest(lateCalendar);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception setting latest value on date validator (" + latest + ")");
                    Trace.trace(TRACE_MASKF, e);
                }
            }
            this.validatorList.add(dateValidator);
            Trace.trace(TRACE_MASKF, "added date validator");
        }
        String required = (String)this.attributes.get("required");
        if (required == null) {
            required = "";
        }
        if (required.equals("TRUE")) {
            RequiredValidator requiredValidator = new RequiredValidator();
            this.validatorList.add(requiredValidator);
            Trace.trace(TRACE_MASKF, "added required validator");
        }
        Trace.trace(TRACE_MASKT, "<- setupValidators()");
    }

    public String format(Object rawObject) {
        Trace.trace(TRACE_MASKT, "<> format()");
        if (this.formatter != null) {
            Trace.trace(TRACE_MASKT, "calling into specified formatter");
            return this.formatter.format(rawObject);
        }
        try {
            String type = (String)this.attributes.get("type");
            if (type == null) {
                type = "";
            }
            if (type.equals("DATE")) {
                Trace.trace(TRACE_MASKT, "calling into date formatter");
                return (String)DateFormatter.convert(rawObject, class$java$lang$String == null ? (class$java$lang$String = AuimlDefaultFormatter.class$("java.lang.String")) : class$java$lang$String);
            }
            if (type.equals("TIME")) {
                Trace.trace(TRACE_MASKT, "calling into time formatter");
                return (String)TimeFormatter.convert(rawObject, class$java$lang$String == null ? (class$java$lang$String = AuimlDefaultFormatter.class$("java.lang.String")) : class$java$lang$String);
            }
            if (type.equals("INTEGRAL")) {
                Trace.trace(TRACE_MASKT, "calling into double formatter then integral formatter");
                Object tmp = ObjectFormatter.convert(rawObject, class$java$lang$Double == null ? (class$java$lang$Double = AuimlDefaultFormatter.class$("java.lang.Double")) : class$java$lang$Double);
                Object tmp2 = ObjectFormatter.convert(tmp, class$java$lang$Integer == null ? (class$java$lang$Integer = AuimlDefaultFormatter.class$("java.lang.Integer")) : class$java$lang$Integer);
                return (String)ObjectFormatter.convert(tmp2, class$java$lang$String == null ? (class$java$lang$String = AuimlDefaultFormatter.class$("java.lang.String")) : class$java$lang$String);
            }
            Trace.trace(TRACE_MASKT, "calling into default formatter");
            return (String)ObjectFormatter.convert(rawObject, class$java$lang$String == null ? (class$java$lang$String = AuimlDefaultFormatter.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (NoStandardFormatterException nsfe) {
            Trace.trace(TRACE_MASKF, "Exception in format(" + rawObject + "): " + nsfe.getMessage());
            return "";
        }
    }

    public Object parse(Object source) throws ValidationException {
        Trace.trace(TRACE_MASKT, "<> parse()");
        String type = (String)this.attributes.get("type");
        if (type == null) {
            type = "";
        }
        try {
            if (type.equals("INTEGRAL")) {
                Double d = (Double)ObjectFormatter.convert(source, class$java$lang$Double == null ? (class$java$lang$Double = AuimlDefaultFormatter.class$("java.lang.Double")) : class$java$lang$Double);
                source = (Integer)ObjectFormatter.convert(d, class$java$lang$Integer == null ? (class$java$lang$Integer = AuimlDefaultFormatter.class$("java.lang.Integer")) : class$java$lang$Integer);
            }
        }
        catch (NoStandardFormatterException nsfe) {
            // empty catch block
        }
        source = this.checkSpinners(source);
        if (this.validatorList != null) {
            Iterator iterator = this.validatorList.iterator();
            while (iterator.hasNext()) {
                Validator validator = (Validator)iterator.next();
                try {
                    validator.validate(source);
                }
                catch (ValidationException ve) {
                    Object o = this.attributes.get("required");
                    if (o == null || !o.equals("TRUE")) {
                        if (source instanceof String) {
                            if (source == null || ((String)source).equals("")) {
                                Trace.trace(TRACE_MASKF, "swallowing exception: " + ve.getMessage());
                                continue;
                            }
                            throw ve;
                        }
                        throw ve;
                    }
                    throw ve;
                }
            }
        }
        Trace.trace(TRACE_MASKF, "passed validators in parse()");
        Object parsedVal = source;
        if (this.formatter != null) {
            Trace.trace(TRACE_MASKT, "calling in to formatter.parse()");
            try {
                if (source instanceof String && this.formatter instanceof DataFormatter) {
                    Trace.trace(TRACE_MASKF, "formatter(String) returns: " + ((DataFormatter)this.formatter).parse((String)source));
                    parsedVal = ((DataFormatter)this.formatter).parse((String)source);
                }
                Trace.trace(TRACE_MASKF, "formatter(Object) returns: " + this.formatter.parse(source));
                parsedVal = this.formatter.parse(source);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "error in formatter.parse(): " + e.getMessage());
                throw new ValidationException(e.getLocalizedMessage());
            }
        } else {
            Trace.trace(TRACE_MASKF, "no formatter specified.");
        }
        Trace.trace(TRACE_MASKF, "Converting parsed val to proper type");
        try {
            if (type.equals("STRING")) {
                return ObjectFormatter.convert(parsedVal, class$java$lang$String == null ? (class$java$lang$String = AuimlDefaultFormatter.class$("java.lang.String")) : class$java$lang$String);
            }
            if (type.equals("INTEGRAL")) {
                return ObjectFormatter.convert(parsedVal, class$java$lang$Integer == null ? (class$java$lang$Integer = AuimlDefaultFormatter.class$("java.lang.Integer")) : class$java$lang$Integer);
            }
            if (type.equals("REAL")) {
                return ObjectFormatter.convert(parsedVal, class$java$lang$Double == null ? (class$java$lang$Double = AuimlDefaultFormatter.class$("java.lang.Double")) : class$java$lang$Double);
            }
            if (type.equals("DATE")) {
                return DateFormatter.convert(parsedVal, class$java$util$Calendar == null ? (class$java$util$Calendar = AuimlDefaultFormatter.class$("java.util.Calendar")) : class$java$util$Calendar);
            }
            if (type.equals("TIME")) {
                return TimeFormatter.convert(parsedVal, class$java$util$Calendar == null ? (class$java$util$Calendar = AuimlDefaultFormatter.class$("java.util.Calendar")) : class$java$util$Calendar);
            }
            return parsedVal;
        }
        catch (Exception e) {
            return parsedVal == null ? null : ("".equals(parsedVal) ? null : parsedVal);
        }
    }

    private Object checkSpinners(Object source) throws ValidationException {
        String min;
        String increment;
        String type = (String)this.attributes.get("type");
        if (type == null) {
            type = "";
        }
        if ((increment = (String)this.attributes.get("increment")) == null) {
            increment = "";
        }
        if ((min = (String)this.attributes.get("minValue")) == null) {
            min = "";
        }
        try {
            if (!increment.equals("") && !min.equals("")) {
                Double tmp;
                double tmpVal;
                double offsetVal;
                double remainder;
                Double incr = (Double)ObjectFormatter.convert(increment, class$java$lang$Double == null ? (class$java$lang$Double = AuimlDefaultFormatter.class$("java.lang.Double")) : class$java$lang$Double);
                double incrVal = incr;
                if (type.equals("INTEGRAL")) {
                    Integer tmp2 = (Integer)ObjectFormatter.convert(source, class$java$lang$Integer == null ? (class$java$lang$Integer = AuimlDefaultFormatter.class$("java.lang.Integer")) : class$java$lang$Integer);
                    int tmpVal2 = tmp2;
                    double offsetVal2 = (double)tmpVal2 - incrVal;
                    double remainder2 = offsetVal2 % incrVal;
                    if (remainder2 != 0.0) {
                        tmpVal2 = remainder2 < incrVal / 2.0 ? (tmpVal2 -= (int)remainder2) : (tmpVal2 += (int)incrVal - (int)remainder2);
                        source = new Integer(tmpVal2).toString();
                    }
                } else if (type.equals("REAL") && (remainder = (offsetVal = (tmpVal = (tmp = (Double)ObjectFormatter.convert(source, class$java$lang$Double == null ? (class$java$lang$Double = AuimlDefaultFormatter.class$("java.lang.Double")) : class$java$lang$Double)).doubleValue()) - incrVal) % incrVal) != 0.0) {
                    tmpVal = remainder < incrVal / 2.0 ? (tmpVal -= remainder) : (tmpVal += incrVal - remainder);
                    source = new Double(tmpVal).toString();
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception in checkSpinners(" + source + ") .. ignoring for now");
            Trace.trace(TRACE_MASKF, e);
        }
        return source;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

